<?php

namespace App\Http\Controllers;

use App\Models\CpanelVersion;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Log;
use Exception;

class cPanelVersionsController extends Controller
{
    public function index(\Illuminate\Http\Request $request) {
        if ($request->ajax()) {
            $data = CpanelVersion::all();
            return \DataTables::of($data)->make(true);
        }
        return view('cpanel_versions.index');
    }

    public function add() {
        return view('cpanel_versions.add');
    }

    public function extract(\Illuminate\Http\Request $request) {
        $rules = [
            'version' => 'required', 
            'decoded_data' => 'required',
            'lisc' => 'required',
            'syslicanitycheck' => 'required',
        ];
        $customMessages = [
            'version' => 'Version cannot be blank.',
            'decoded_data' => 'Key Decoded Data cannot be blank.',
            'lisc' => 'Lisc base64encoded Data cannot be blank.',
            'syslicanitycheck' => 'cPsanitycheck base64encoded Data cannot be blank.',
        ];
        $this->validate($request, $rules, $customMessages);
        $version = $request->version;
        $decoded_data = $request->decoded_data;
        $liscenseBase64 = $request->lisc;
        $syslicanitycheckBase64 = $request->syslicanitycheck;
        $checkModel = CpanelVersion::where('cpversion', '=', $version)->first();
        if(!$checkModel) {
            $exploded = explode(",", $decoded_data);
            $lic = $this->getValues($exploded); 
            if($lic) {
                $model = new CpanelVersion();
                $model->cpversion = $version;
                $model->FO = ($lic['FO'] ?? null);
                $model->FMA = ($lic['FMA'] ?? null);
                $model->FIP = ($lic['FIP'] ?? null);
                $model->FR = ($lic['FR'] ?? null);
                $model->FV = ($lic['FV'] ?? null);
                $model->FMM = ($lic['FMM'] ?? null);
                $model->FD = ($lic['FD'] ?? null);
                $model->FIU = ($lic['FIU'] ?? null);
                $model->FIV = ($lic['FIV'] ?? null);
                $model->FIL = ($lic['FIL'] ?? null);
                $model->FK = ($lic['FK'] ?? null);
                $model->FKT = ($lic['FKT'] ?? null);
                $model->FKTH = ($lic['FKTH'] ?? null);
                $model->FN = ($lic['FN'] ?? null);
                $model->EW = ($lic['EW'] ?? null);
                $model->license = ($liscenseBase64 ?? null);
                $model->syslicanitycheck = ($syslicanitycheckBase64 ?? null);
                if($model->save()) {
                    return back()->with('success', 'Created Sucessfully');
                }
                return back()->withErrors('Record Not Saved. Something wrong with decoded data.');
            }
            return back()->withErrors('Error in extracting');
        }
        return back()->withErrors('This cPanel Version (' . $version . ') already exiest in the system');
    }

    private function getValues($content = null) {
        $returnArray = [];
        if($content) {
            foreach($content as $c) {
                $exploded = explode("=", $c);
                $returnArray[$exploded[0]] = $exploded[1]; 
            }
        }
        return $returnArray;
    }

    public function bulk_delete(\Illuminate\Http\Request $request) {
        CpanelVersion::destroy($request->id);
        return back()->with('success', 'Items deleted successfully');
    }
}
